//
//  WXKBookmarkWindowController.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/23.
//  Copyright FUJIDANA 2006. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKBookmarkWindowController.h"


@implementation WXKBookmarkWindowController


#pragma mark Initialization and deallocation

- (id)init
{
	NSURL *url = [[self class] URLWithPersistentStoreDirectory:@"Kyopon Utilities" filename:@"bookmarks.wxkxml"];
	
	self = [super initWithWindowNibName:@"BookmarkWindow" URLForPersistentStore:url];
	
	if (self != nil) {
	}
	return self;
}

- (void)windowWillLoad
{
	[super windowWillLoad];
	
	[self setWindowFrameAutosaveName:@"BookmarkWindowFrame"];
	
	NSManagedObjectContext	*context		= [self managedObjectContext];
	NSFetchRequest			*fetchRequest	= [[NSFetchRequest alloc] init];
	NSEntityDescription		*entity			= [NSEntityDescription entityForName:@"BookmarkFolder" inManagedObjectContext:context];
	[fetchRequest setEntity:entity];
	
	NSError *fetchError;
	NSArray *fetchResults = [context executeFetchRequest:fetchRequest error:&fetchError];
	if (fetchResults == nil) {
		//
	} else if ([fetchResults count] != 20) {
		[[context undoManager] disableUndoRegistration];
		
		NSEnumerator *enumerator = [fetchResults objectEnumerator];
		NSManagedObject *object;
		while (object = [enumerator nextObject]) {
			[context deleteObject:object];
		}
		
		int i;
		for (i = 0; i < 20; i++) {
			object = [NSEntityDescription insertNewObjectForEntityForName:@"BookmarkFolder" inManagedObjectContext:context];
			[object setValue:[NSNumber numberWithLong:i] forKey:@"order"];
			[object setValue:[NSString stringWithFormat:@"%d", i] forKey:@"title"];
		}
		
		[[context undoManager] enableUndoRegistration];
		
	}
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	[self setupToolbarWithIdentifier:@"Bookmark Utility"];
	[self setupForDragAndDropOperation];
	
	[self showWindow:nil];
	
}

#pragma mark Overriding superclass

- (NSString *)localizedItemName
{
	return NSLocalizedStringFromTable(@"bookmark", @"BookmarkLocalizable", @"localizedItemName");
}

- (NSString *)localizedPluralItemName
{
	return NSLocalizedStringFromTable(@"bookmarks", @"BookmarkLocalizable", @"localizedPluralItemName");
}

- (NSString *)indexManagerEntityName
{
	return @"BookmarkIndexManager";
}

#pragma mark Methods delegated by NSToolbar

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = [super toolbar:toolbar itemForItemIdentifier:itemIdentifier willBeInsertedIntoToolbar:flag];
	
	if ([[toolbarItem itemIdentifier] isEqualToString:FJDItemsInFolderToolbarNewItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"New", @"BookmarkLocalizable", @"toolbarItem.newItem.label")];
	} else if ([[toolbarItem itemIdentifier] isEqualToString:FJDItemsInFolderToolbarDeleteItemIdentifier]) {
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Delete", @"BookmarkLocalizable", @"toolbarItem.deleteItem.label")];
	}
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
		FJDItemsInFolderToolbarNewItemIdentifier,
		FJDItemsInFolderToolbarDeleteItemIdentifier, 
		NSToolbarSeparatorItemIdentifier,
		WXKToolbarReceiveItemIdentifier, 
		WXKToolbarSendItemIdentifier, 
		NSToolbarFlexibleSpaceItemIdentifier,
		FJDItemsInFolderToolbarSearchItemIdentifier, 
		nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
		FJDItemsInFolderToolbarNewItemIdentifier,
		FJDItemsInFolderToolbarDeleteItemIdentifier, 
		FJDItemsInFolderToolbarPreviousItemIdentifier,
		FJDItemsInFolderToolbarNextItemIdentifier,
		FJDItemsInFolderToolbarPreviousFolderIdentifier,
		FJDItemsInFolderToolbarNextFolderIdentifier,
		FJDItemsInFolderToolbarDeselectSortIdentifier,
		FJDItemsInFolderToolbarSearchItemIdentifier, 
		FJDIndexedItemsToolbarReindexSelectionIdentifier,
		WXKToolbarReceiveItemIdentifier,
		WXKToolbarSendItemIdentifier,
		WXKToolbarAddressUtilityItemIdentifier,
//		WXKToolbarBookmarkUtilityItemIdentifier,
		WXKToolbarFileUtilityItemIdentifier,
		WXKToolbarMailUtilityItemIdentifier,
		NSToolbarPrintItemIdentifier,
		//NSToolbarShowColorsItemIdentifier,
		//NSToolbarShowFontsItemIdentifier, 
		NSToolbarCustomizeToolbarItemIdentifier,
		NSToolbarSeparatorItemIdentifier, 
		NSToolbarSpaceItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier, 
		nil];
}

@end
